-- events for main menu

bgpanamount = 0;
bgpandirection = 1;

timer = 0;
profiletext = "";

emitters = 5;
interval = 0;



function OnLoad ()
	CacheSound ("music/mainmenu.ogg");
end;

function UpdateProfileName ()
	welcome_msg = string.format ("Welcome %s", GetProfileStat ("name"));
	SetProperty ("ProfileName:label.text", welcome_msg);
end;

function OnEnter ()
	Azkend_SetMenuBackground ("worldmap/backgrounds/bg-mainmenu.jpg");
	--Azkend_SetMenuBackground ("worldmap/backgrounds/bg-0007.jpg");

	SetProperty ("glow:blend_mode", "ADDITIVE");
	SwitchMusic ("music/mainmenu.ogg", 0, 2);
	profiletext = GetProperty("Profiles:button.text");
	-- set the welcome message
	UpdateProfileName ();
	
	-- if the profile has no name, let's ask one
	if (GetProfileStat ("name") == "") then
		PushScreen ("NewProfile");
	end;
	
	time = 0
	interval = 0
	emitters =  CountLabelsByName("dummy_rain_");

end;

function OnLeave ()
    
end;

function CountLabelsByName(name)
	response = 1;
    iter = 0;
	repeat
		result = GetProperty("dummy_rain_"..iter..":position.x");
		if(result == nil) then
			response = 0;
		else
			iter = iter + 1;
		end;			
	until response==0
	return iter;
end;

function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
	if (name == "Hidden") then
		PushScreen ("Developer");
		return;
	end;
		
	if (name == "Options") then
		PushScreen ("Options");
		return;
	end;
	
	if (name == "Profiles") then
		PushScreen ("Profiles");
		return;
	end;
	
	if (name == "Instructions") then
		PushScreen ("Instructions");
		return;
	end;
	
	if (name == "HighScores") then
		PushScreen ("HighScores");
		return;
	end;
	
	if (name == "Trophies") then
		PushScreen ("Trophyscreen");
		return;
	end;
	
	if (name == "Quit") then
		NexusShutdown ();
		return;
	end;
	
	
	if (name == "Play") then
		PushScreen ("PlayMenu");
		return;
	end;
	
	-- if any of the play buttons were pressed, set and start the game
	if (name == "PlayQ") then
		
		-- set the active game mode
		num = GetGameByName ("AzkendQuestMode");
		Print ("Game Num is " .. num .. "\n");
		
		if (num == -1) then
			return;
		end;
		
		SetGame (num);	
		SetVar ("GameMode", "QUEST");
		
		if (IsSaveGameFileAvailable ()) then
			PushScreen ("ContinueOldGame");
		else
			InitNewGame ();
			SetGameLevel (1);
			SwitchScreen ("StoryIntro");
		end;
	end;

	
end;


function OnUpdate (tdelta)

	timer = timer + tdelta;

	interval = interval + tdelta;
	
	UpdateProfileName ();
	
	
	-- ze pulsating text!
	color_r = 255;	
	color_b = (185+70 * math.cos(2 * timer));
	color_g = (210+45 * math.cos(2 * timer));	
	colorstring = string.format("%x%x%x", color_r, color_g, color_b);
	SetProperty("Profiles:button.text", string.format(profiletext, colorstring));
	
	bgpanamount = bgpanamount + (bgpandirection * (4*tdelta));
	if(bgpanamount > 60) then
		bgpandirection = -1;
	end;
	
	if(bgpanamount < 1) then	
		bgpandirection = 1;
	end;
	
	--totalpan = bgpanamount - 20;
	--SetProperty ("backg:position_offset.x", bgpanamount);	
	SetProperty ("backg:position_offset.x", 30 + 30 * math.cos (0.2 * timer));
	--SetProperty ("HighScores:button.text", "pan:"..bgpanamount);
	
	SetProperty ("glow:alpha", math.sin(timer));	
end;


function OnDrawComp(name) 
	--if(interval > 0.2) then
		--for i = 0, emitters-1, 1 do			
			--SpawnFX ("fxs/rain.lua", GetProperty("dummy_rain_"..i..":position.x"), GetProperty("dummy_rain_"..i..":position.y"), 180, 0);			
		--end;
		--interval = 0;
	--end;
end;

function OnDraw ()

end;
